set echo on
WHENEVER SQLERROR EXIT FAILURE;

set pagesize 10000

-- Assumption: SEM Network is already created and model M1 does not exist
-- Assumption: Staging table, stable, does not exist
-- Assumption: "rdfuser identified by rdfuser" exists and has CONNECT,RESOURCE

connect rdfuser/rdfuser

-- PHASE 1: Initial load: issue sqlldr command
create table stable (
                     RDF$STC_sub varchar2(4000) not null, 
                     RDF$STC_pred varchar2(4000) not null,
                     RDF$STC_obj varchar2(4000) not null, 
                     RDF$STC_sub_ext varchar2(64), 
                     RDF$STC_pred_ext varchar2(64),
                     RDF$STC_obj_ext varchar2(64),
                     RDF$STC_canon_ext varchar2(64)
);

host sqlldr userid=rdfuser/rdfuser control=bulkload.ctl data=bulkload0.nt direct=true skip=0 load=1000000 discardmax=0 bad=d0.bad discard=d0.rej log=d0.log errors=1000000

-- verify staging table data
select RDF$STC_sub,RDF$STC_pred,RDF$STC_obj from stable order by 1,2,3;

-- create sem model
create table atab (triple sdo_rdf_triple_s);
exec sem_apis.create_sem_model('M1', 'ATAB', 'TRIPLE');

-- MDSYS needs some privileges
grant INSERT on atab to MDSYS;
grant SELECT, UPDATE(RDF$STC_sub_ext,RDF$STC_pred_ext,RDF$STC_obj_ext,
                     RDF$STC_canon_ext) 
      on stable to MDSYS;

-- invoke bulk-load from staging table
exec sem_apis.bulk_load_from_staging_table('M1','rdfuser','stable');

-- check app table content
select a.triple.get_subject() app_sub, a.triple.get_property() app_pred,
       a.triple.get_obj_value() app_obj 
from atab a order by 1,2,3;

-- should return no rows
select * from (
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
minus
select RDF$STC_sub sub,RDF$STC_pred sub,RDF$STC_obj obj from stable
);

select * from (
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj from stable
minus
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
);

-- PHASE 3: APPEND ADDITIONAL DATA

-- Note: sqlldr control file specifies TRUNCATE (to truncate the old data)
host sqlldr userid=rdfuser/rdfuser control=bulkload.ctl data=bulkload1.nt direct=true skip=0 load=1000000 discardmax=0 bad=d1.bad discard=d1.rej log=d1.log errors=1000000

select RDF$STC_sub,RDF$STC_pred,RDF$STC_obj from stable order by 1,2,3;

-- bulk-append
exec sem_apis.bulk_load_from_staging_table('M1','rdfuser','stable');

select a.triple.get_subject() app_sub, a.triple.get_property() app_pred,
       a.triple.get_obj_value() app_obj 
from atab a order by 1,2,3;

-- should return only the old rows (before append) plus rows involving bNodes
select * from (
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
minus
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj from stable
) order by 1,2,3;
-- should return the rows involving bNodes in the new batch appended
select * from (
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj from stable
minus
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
) order by 1,2,3;

-- test bulk-load of data involving xsd:date, xsd:time, and xsd:dateTime
truncate table atab;

EXEC sem_apis.drop_sem_model('M1');
exec sem_apis.create_sem_model('M1', 'ATAB', 'TRIPLE');

host sqlldr userid=rdfuser/rdfuser control=bulkload.ctl data=bulkload2.nt direct=true skip=0 load=1000000 discardmax=0 bad=d2.bad discard=d2.rej log=d2.log errors=1000000
select RDF$STC_sub,RDF$STC_pred,RDF$STC_obj from stable order by 1,2,3;

-- bulk-load
exec sem_apis.bulk_load_from_staging_table('M1','rdfuser','stable');

select a.triple.get_subject() app_sub, a.triple.get_property() app_pred,
       a.triple.get_obj_value() app_obj 
from atab a order by 1,2,3;

-- should return no rows
select * from (
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
minus
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj from stable
);

select * from (
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj from stable
minus
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
);

-- test bulk-load of (mainly) family data (containing URI w/o <>, QNames,..)
truncate table atab;

EXEC sem_apis.drop_sem_model('M1');
exec sem_apis.create_sem_model('M1', 'ATAB', 'TRIPLE');

host sqlldr userid=rdfuser/rdfuser control=bulkload.ctl data=bulkload3.nt direct=true skip=0 load=1000000 discardmax=0 bad=d3.bad discard=d3.rej log=d3.log errors=1000000

select RDF$STC_sub,RDF$STC_pred,RDF$STC_obj from stable order by 1,2,3;

-- bulk-load
exec sem_apis.bulk_load_from_staging_table('M1','rdfuser','stable');

select a.triple.get_subject() app_sub, a.triple.get_property() app_pred,
       a.triple.get_obj_value() app_obj 
from atab a order by 1,2,3;

-- should return no rows
select * from (
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
minus
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj from stable
);

select * from (
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj from stable
minus
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
from atab a
);

-- load additional (non-rdf) col
truncate table atab;
alter table atab add (id_in_word varchar2(30));

alter table stable add (id_in_word varchar2(30));

host sqlldr userid=rdfuser/rdfuser control=bulkload3_plus_non_rdf.ctl data=bulkload3_plus_non_rdf.nt direct=true skip=0 load=1000000 discardmax=0 bad=d3_plus_non_rdf.bad discard=d3_plus_non_rdf.rej log=d3_plus_non_rdf.log errors=1000000

alter table atab add (id_num number);

alter table stable add (id_num number);
update stable set id_num=rownum;

select RDF$STC_sub,RDF$STC_pred,RDF$STC_obj,id_in_word,id_num from stable order by id_num;

-- bulk-load
exec sem_apis.bulk_load_from_staging_table('M1','rdfuser','stable');

select a.triple.get_subject() app_sub, a.triple.get_property() app_pred,
       a.triple.get_obj_value() app_obj 
       , id_in_word, id_num
from atab a order by id_num;

-- should return no rows
select * from (
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
       , id_in_word, id_num
from atab a
minus
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj,id_in_word,id_num from stable
)
;
select * from (
select RDF$STC_sub sub,RDF$STC_pred pred,RDF$STC_obj obj,id_in_word,id_num from stable
minus
select a.triple.get_subject() sub, a.triple.get_property() pred,
       a.triple.get_obj_value() obj 
       , id_in_word, id_num
from atab a
);

-- cleanup
drop table stable;

EXEC sem_apis.drop_sem_model('M1');
drop table atab;
